<?php
include "admin/conn.php";

/* Pagination */
$limit = 4;
$page = isset($_GET['page']) ? (int)$_GET['page'] : 1;
$start = ($page - 1) * $limit;

/* Fetch news */
$result = mysqli_query(
    $con,
    "SELECT * FROM news ORDER BY id DESC LIMIT $start, $limit"
);

/* Total pages */
$total_q = mysqli_query($con, "SELECT COUNT(id) AS total FROM news");
$total = mysqli_fetch_assoc($total_q)['total'];
$total_pages = ceil($total / $limit);
?>

<!DOCTYPE html>
<html lang="en">
    
<meta http-equiv="content-type" content="text/html;charset=utf-8" />
<head>
        <!-- :: Required Meta Tags -->
        <meta charset="utf-8">
        <meta http-equiv="X-UA-Compatible" content="IE=edge">
        <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
        <meta name="description" content="">
        <meta name="keywords" content="">
        
        <!-- :: Favicon -->
        <link rel="icon" type="image/png" href="assets/images/favicon.png">

        <!-- :: Title -->
        <title>Dekwaneh Municipality</title>

        <!-- :: Google Fonts -->
        <link rel="stylesheet" href="https://fonts.googleapis.com/css2?family=Open+Sans:wght@400;600;700;800&amp;display=swap">
        <link rel="stylesheet" href="https://fonts.googleapis.com/css2?family=Raleway:wght@400;600;700;800&amp;display=swap">
                
        <!-- :: Flaticon CSS -->
        <link rel="stylesheet" href="assets/fonts/flaticon/css/flaticon.css">
        
        <!-- :: Fontawesome CSS -->
		<link rel="stylesheet" href="assets/fonts/fontawesome/css/all.min.css">

        <!-- :: Bootstrap CSS -->
        <link rel="stylesheet" href="assets/css/bootstrap.min.css">
        
        <!-- :: Owl Carousel CSS -->
        <link rel="stylesheet" href="assets/css/owl.carousel.min.css">
        <link rel="stylesheet" href="assets/css/owl.theme.default.css">
        
        <!-- :: Animate CSS -->
        <link rel="stylesheet" href="assets/css/animate.css">
        
        <!-- :: Style CSS -->
        <link rel="stylesheet" href="assets/css/style.css">

        <!-- :: Style Responsive CSS -->
        <link rel="stylesheet" href="assets/css/responsive.css">
        <link href="https://fonts.googleapis.com/css2?family=Tajawal:wght@300;400;500;700&family=Cairo:wght@400;600;700&display=swap" rel="stylesheet">

        <!--[if lt IE 9]>
            <script src="https://oss.maxcdn.com/libs/html5shiv/3.7.0/html5shiv.js"></script>
            <script src="https://oss.maxcdn.com/libs/respond.js/1.4.2/respond.min.js"></script>
        <![endif]-->
    </head>
    <body>
        <!-- :: Loading -->
        <div class="loading">
            <div class="banner">
                <div class="sk-chase">
                    <div class="sk-chase-dot"></div>
                    <div class="sk-chase-dot"></div>
                    <div class="sk-chase-dot"></div>
                    <div class="sk-chase-dot"></div>
                    <div class="sk-chase-dot"></div>
                    <div class="sk-chase-dot"></div>
                </div>
            </div>
        </div>
        
        <!-- :: Header Bar -->
       <?php include 'header.php';?>

        <!-- :: Breadcrumb Header -->
		<section class="breadcrumb-header" id="page">
            <div class="overlay"></div>
            <div class="container">
                <div class="breadcrumb-info text-right">
                    <h1>الأخبار والإعلانات</h1>
                </div>

            </div>
        </section>

            
        <!-- :: Blog -->
<section class="blog py-100" dir= rtl>
    <div class="container">
         <div class="row">
            <div class="col-md-12 offset-md-2">
                <div class="sec-title text-center">
                    <h2>الأخبار والإعلانات</h2>
                    <h3>تابع آخر الأخبار والإعلانات والبيانات الصادرة عن بلدية الدكوانة</h3>

                </div>
            </div>
        </div>
        <div class="row">
        
            <?php if(mysqli_num_rows($result) > 0): ?>
                <?php while($row = mysqli_fetch_assoc($result)): ?>
                    <div class="col-md-6 col-lg-4 mb-4">
                        <div class="blog-item h-100">

                            <div class="img-box">
                                <?php if(!empty($row['img']) && file_exists("admin/uploads/".$row['img'])): ?>
                                    <img class="img-fluid"
                                         src="admin/uploads/<?php echo htmlspecialchars($row['img']); ?>"
                                         alt="<?php echo htmlspecialchars($row['title']); ?>">
                                <?php else: ?>
                                    <img class="img-fluid"
                                         src="assets/images/blog/default.jpg"
                                         alt="news">
                                <?php endif; ?>
                            </div>

                            <div class="text-box">
                                <div class="admin-post">
                                    <div class="info-post">
                                        <span><?php echo htmlspecialchars($row['category']); ?></span>
                                        <span>
                                            <?php echo date("d M Y", strtotime($row['created_at'] ?? date('Y-m-d'))); ?>
                                        </span>
                                    </div>
                                </div>

                                <div class="post">
                                    <h5 class="title-post">
                                        <a href="single-news.php?id=<?php echo $row['id']; ?>">
                                            <?php echo htmlspecialchars($row['title']); ?>
                                        </a>
                                    </h5>

                                    <p>
                                        <?php
                                        echo mb_substr(strip_tags($row['short']), 0, 120, 'UTF-8');
                                        ?>
                                    </p>
                                </div>
                            </div>

                        </div>
                    </div>
                <?php endwhile; ?>
            <?php else: ?>
                <div class="col-12 text-center">
                    <p>لا توجد أخبار أو إعلانات حالياً</p>
                </div>
            <?php endif; ?>

        </div>

        <!-- Pagination -->
        <?php if($total_pages > 1): ?>
        <div class="pagination-blog-area text-center mt-4">
            <ul class="pagination justify-content-center">
                <?php if($page > 1): ?>
                    <li><a href="?page=<?php echo $page-1; ?>">Prev</a></li>
                <?php endif; ?>

                <?php for($i=1; $i<=$total_pages; $i++): ?>
                    <li class="<?php echo ($page == $i) ? 'active' : ''; ?>">
                        <a href="?page=<?php echo $i; ?>"><?php echo $i; ?></a>
                    </li>
                <?php endfor; ?>

                <?php if($page < $total_pages): ?>
                    <li><a href="?page=<?php echo $page+1; ?>">Next</a></li>
                <?php endif; ?>
            </ul>
        </div>
        <?php endif; ?>

    </div>
</section>

        
        
        <!-- :: Footer -->
		<?php include 'footer.php';?>
        
        <!-- :: Scroll Up -->
        <div class="scroll-up">
            <a href="#page" class="move-section">
                <i class="fas fa-angle-up"></i>
            </a>
        </div>
        
        <!-- :: JS -->
        <!-- :: jQuery -->
        <script src="assets/js/jquery-3.5.1.min.js"></script>

        <!-- :: Popper -->
        <script src="assets/js/popper.min.js"></script>

        <!-- :: Bootstrap -->
        <script src="assets/js/bootstrap.min.js"></script>
        
        <!-- :: Owl Carousel -->
        <script src="assets/js/owl.carousel.min.js"></script>
        
        <!-- :: Waypoints -->
        <script src="assets/js/jquery.waypoints.min.js"></script>

        <!-- :: CounterUp -->
        <script src="assets/js/jquery.counterup.min.js"></script>
        
        <!-- :: Main -->
        <script src="assets/js/main.js"></script>
    </body>

</html>