<!DOCTYPE html>
<html lang="en">
    
<meta http-equiv="content-type" content="text/html;charset=utf-8" />
<head>
        <!-- :: Required Meta Tags -->
        <meta charset="utf-8">
        <meta http-equiv="X-UA-Compatible" content="IE=edge">
        <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
        <meta name="description" content="">
        <meta name="keywords" content="">
        
        <!-- :: Favicon -->
        <link rel="icon" type="image/png" href="assets/images/favicon.png">

        <!-- :: Title -->
        <title>Dekwaneh Municipality</title>

        <!-- :: Google Fonts -->
        <link rel="stylesheet" href="https://fonts.googleapis.com/css2?family=Open+Sans:wght@400;600;700;800&amp;display=swap">
        <link rel="stylesheet" href="https://fonts.googleapis.com/css2?family=Raleway:wght@400;600;700;800&amp;display=swap">
                
        <!-- :: Flaticon CSS -->
        <link rel="stylesheet" href="assets/fonts/flaticon/css/flaticon.css">
        
        <!-- :: Fontawesome CSS -->
		<link rel="stylesheet" href="assets/fonts/fontawesome/css/all.min.css">

        <!-- :: Bootstrap CSS -->
        <link rel="stylesheet" href="assets/css/bootstrap.min.css">
        
        <!-- :: Owl Carousel CSS -->
        <link rel="stylesheet" href="assets/css/owl.carousel.min.css">
        <link rel="stylesheet" href="assets/css/owl.theme.default.css">
        
        <!-- :: Animate CSS -->
        <link rel="stylesheet" href="assets/css/animate.css">
        
        <!-- :: Style CSS -->
        <link rel="stylesheet" href="assets/css/style.css">

        <!-- :: Style Responsive CSS -->
        <link rel="stylesheet" href="assets/css/responsive.css">
        <link href="https://fonts.googleapis.com/css2?family=Tajawal:wght@300;400;500;700&family=Cairo:wght@400;600;700&display=swap" rel="stylesheet">

        <!--[if lt IE 9]>
            <script src="https://oss.maxcdn.com/libs/html5shiv/3.7.0/html5shiv.js"></script>
            <script src="https://oss.maxcdn.com/libs/respond.js/1.4.2/respond.min.js"></script>
        <![endif]-->
    </head>
    <body>
        <!-- :: Loading -->
        <div class="loading">
            <div class="banner">
                <div class="sk-chase">
                    <div class="sk-chase-dot"></div>
                    <div class="sk-chase-dot"></div>
                    <div class="sk-chase-dot"></div>
                    <div class="sk-chase-dot"></div>
                    <div class="sk-chase-dot"></div>
                    <div class="sk-chase-dot"></div>
                </div>
            </div>
        </div>
        
        <!-- :: Header Bar -->
       <?php include 'header.php';?>

        
      
       <!-- :: Header -->
        <section class="header" id="page">
            <div class="overlay">
                <div class="container">
                    <div class="row">
                        <div class="col-lg-10 offset-lg-1">
                            <div class="banner text-center">
                                <img class="img-fluid logo-handline" src="assets/images/logo/03_logo.png" alt="Logo Header">

                                <div class="top-handline">مرحباً بكم في الموقع الرسمي لبلدية الدكوانة</div>

                                <h1 class="handline">
                                    دليلكم الشامل للخدمات البلدية، الأخبار، المشاريع، والتواصل مع البلدية
                                </h1>
                                
                                <div class="buttons">
                                    <a href="about.php" class="move-section btn-1">ابدأ التصفح</a>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </section>

        
       <!-- :: Features -->
<section class="features">
    <div class="features-box owl-carousel owl-theme">

        <div class="item-features">
            <i class="fas fa-user-tie"></i> <!-- رئيس وأعضاء البلدية -->
            <div class="text-item">
              <a href="about.php">
                  <span>تعرف على</span>
                <h4>رئيس وأعضاء البلدية</h4>
              </a>  
            </div>
        </div>

      
        <div class="item-features">
            <i class="fas fa-envelope-open-text"></i> <!-- تقديم شكوى أو طلب -->
            <div class="text-item">
                <a href="contact.php">
                <span>تقديم</span>
                <h4>شكوى أو طلب</h4>
                </a>
            </div>
        </div>

        <div class="item-features">
            <i class="fas fa-clock"></i> <!-- حجز موعد -->
            <div class="text-item">
                <a href="contact.php">
                <span>حجز</span>
                <h4>موعد مسبق</h4>
                </a>
            </div>
        </div>

        <div class="item-features">
            <i class="fas fa-cogs"></i> <!-- عرض الخدمات -->
            <div class="text-item">
                 <a href="services.php">
                <span>عرض</span>
                <h4>الخدمات البلدية</h4>
                </a>
            </div>
        </div>

    </div>
</section>



        
        <!-- :: About Us -->
		<section class="about py-100" id="about">
            <div class="overlay-2"></div>
            <div class="container">
                <div class="row">
                    <div class="col-lg-6">
                        <div class="text-box">
                            <div class="sec-title">
                                <h2>عن البلدية</h2>
                                <h3>نبذة تاريخية</h3>
                            </div>
                            <p>بلدية الدكوانة – مار روكس – ضهر الحصين هي واحدة من أقدم البلديات في لبنان، تأسست رسمياً عام 1952 بعد توحيد منطقتي الدكوانة و مار روكس – ضهر الحصين.</p>
                            <p>تعتبر الدكوانة مركزاً اقتصادياً وتجارياً وإدارياً، كما تحتوي على تراث تاريخي غني يعود لأزمنة الفينيقيين والرومانيين والحقب اللاحقة. البلدة تمتاز بتنوعها الجغرافي بين السواحل والهضاب، وتاريخها مرتبط بالقديس مار روكز والمنطقة المحيطة به.</p>
                           
                            <ul class="core-about-us">
                                <li><i class="fas fa-check"></i><h4>جذور تاريخية وثقافة غنية</h4></li>
                                <li><i class="fas fa-check"></i><h4>بلدية تأسست لتعزيز الخدمات المحلية</h4></li>
                                <li><i class="fas fa-check"></i><h4>معالم دينية وتراثية مهمة</h4></li>
                                <li><i class="fas fa-check"></i><h4>التزام بتطوير المجتمع وجودة الحياة</h4></li>
                            </ul>
                            
                            <div class="buttons"  style="margin-top: 20px;">
                                    <a href="about.php" class="move-section btn-1"> اقرأ المزيد</a>
                            </div>    
                        </div>
                    </div>
                    <div class="col-lg-6">
                        <div class="img-box">
                            <div class="about-img">
                                <img class="img-fluid" src="assets/images/about/01_about.JPG" alt="عن البلدية">
                            </div>
                            <div class="atterney-grow">
                                <div class="atterney-grow-box">
                                    <h5>رؤية ورسالة البلدية</h5>
                                    <span>نسعى لتقديم أفضل الخدمات للمواطنين، الحفاظ على التراث التاريخي والثقافي للبلدة، وتعزيز التنمية المستدامة بما يضمن رفاهية المجتمع المحلي وجودة حياة جميع السكان.</span>
                                </div>

                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </section>

        
       
        <!-- :: Services -->
        <section class="services py-100-70">
            <div class="container">
                <div class="row">
                    <div class="col-md-8 offset-md-2">
                        <div class="sec-title text-center">
                            <h2>الخدمات البلدية</h2>
                            <h3>أهم الخدمات التي نقدمها للمواطنين</h3>
                        </div>
                    </div>
                </div>
                <div class="row arabic">
                    <div class="col-md-6 col-lg-4">
                        <div class="services-item">
                            <div class="icon">
                                <i class="fas fa-file-alt"></i>
                                <i class="fas fa-check"></i>
                            </div>
                            <h4>الخدمات الإدارية</h4>
                            <p>إفادة شغور، إفادة محتويات، براءة ذمة، وغيرها من الخدمات الإدارية للمواطنين.</p>
                            <a href="#">المزيد</a>
                        </div>
                    </div>
                    <div class="col-md-6 col-lg-4">
                        <div class="services-item">
                            <div class="icon">
                                <i class="fas fa-building"></i>
                                <i class="fas fa-check"></i>
                            </div>
                            <h4>خدمات البناء والعقار</h4>
                            <p>رخصة بناء، تسوية مخالفة، إفراز أراضي، تجديد تراخيص، وغيرها.</p>
                            <a href="#">المزيد</a>
                        </div>
                    </div>
                    <div class="col-md-6 col-lg-4">
                        <div class="services-item">
                            <div class="icon">
                                <i class="fas fa-store"></i>
                                <i class="fas fa-check"></i>
                            </div>
                            <h4>ترخيص الأعمال والمحلات</h4>
                            <p>ترخيص الإعلان، المهن بالتجول، محلات تجارية، ومحطات توزيع المحروقات.</p>
                            <a href="#">المزيد</a>
                        </div>
                    </div>
                    <div class="col-md-6 col-lg-4">
                        <div class="services-item">
                            <div class="icon">
                                <i class="fas fa-money-bill-wave"></i>
                                <i class="fas fa-check"></i>
                            </div>
                            <h4>الخدمات المالية</h4>
                            <p>دفع الرسوم، تقسيط، إعفاء المعوقين من الرسوم على القيمة التأجيرية، وغيرها.</p>
                            <a href="#">المزيد</a>
                        </div>
                    </div>
                    <div class="col-md-6 col-lg-4">
                        <div class="services-item">
                            <div class="icon">
                                <i class="fas fa-water"></i>
                                <i class="fas fa-check"></i>
                            </div>
                            <h4>البنية التحتية والمرافق</h4>
                            <p>ربط مجرور المياه، إشغال الأملاك العامة، شكاوى الطرقات والمياه، وغيرها.</p>
                            <a href="#">المزيد</a>
                        </div>
                    </div>
                    <div class="col-md-6 col-lg-4">
                        <div class="services-item">
                            <div class="icon">
                                <i class="fas fa-gavel"></i>
                                <i class="fas fa-check"></i>
                            </div>
                            <h4>القوانين والأنظمة البلدية</h4>
                            <p>الإطلاع على القوانين، التعاميم، وتنظيم الإجراءات بما يخدم المواطنين.</p>
                            <a href="#">المزيد</a>
                        </div>
                    </div>
                </div>
            </div>
        </section>

    <section class="services home-3 py-100-70">
        <div class="container">
            <div class="row">
                <div class="col-md-8 offset-md-2">
                    <div class="sec-title text-center">
                        <h2>أعضاء المجلس البلدي</h2>
                        <h3> البلدية </h3>
                    </div>
                </div>
            </div>
    
            <div class="services-box owl-carousel owl-theme">
    
                <!-- ===================== البلدية ===================== -->
             
    
                <div class="services-item"><div class="item-img"><img class="img-fluid" src="assets/images/team/انطوان انطوان شختورة.JPG" alt=""></div></div>
                <div class="services-item"><div class="item-img"><img class="img-fluid" src="assets/images/team/جورج روكس صادر.JPG" alt=""></div></div>
                <div class="services-item"><div class="item-img"><img class="img-fluid" src="assets/images/team/داني متري متى.JPG" alt=""></div></div>
                <div class="services-item"><div class="item-img"><img class="img-fluid" src="assets/images/team/ريمون آليا أبي عبود.JPG" alt=""></div></div>
                <div class="services-item"><div class="item-img"><img class="img-fluid" src="assets/images/team/زياد أنيس وازن.JPG" alt=""></div></div>
    
                <div class="services-item"><div class="item-img"><img class="img-fluid" src="assets/images/team/ميرنا زخيا صفير.JPG" alt=""></div></div>
                <div class="services-item"><div class="item-img"><img class="img-fluid" src="assets/images/team/طوني جوزف رزق.JPG" alt=""></div></div>
                <div class="services-item"><div class="item-img"><img class="img-fluid" src="assets/images/team/مارون عبدو الناكوزي.JPG" alt=""></div></div>
                <div class="services-item"><div class="item-img"><img class="img-fluid" src="assets/images/team/زكريا عطيه سلوم.JPG" alt=""></div></div>
                <div class="services-item"><div class="item-img"><img class="img-fluid" src="assets/images/team/تانيا جورج بوعبود.JPG" alt=""></div></div>
    
                <div class="services-item"><div class="item-img"><img class="img-fluid" src="assets/images/team/جان الياس الصيفي.JPG" alt=""></div></div>
                <div class="services-item"><div class="item-img"><img class="img-fluid" src="assets/images/team/بيار عبده عطالله.JPG" alt=""></div></div>
                <div class="services-item"><div class="item-img"><img class="img-fluid" src="assets/images/team/رالف ابراهيم جدعون.JPG" alt=""></div></div>
                <div class="services-item"><div class="item-img"><img class="img-fluid" src="assets/images/team/جوزف عبده الحمصي.JPG" alt=""></div></div>
    
               
    
            </div>
        </div>
    </section>

         <section class="services home-3">
    <div class="container">
        <div class="row">
            <div class="col-md-8 offset-md-2">
                <div class="sec-title text-center">
                    <h3>المخاتير </h3>
                </div>
            </div>
        </div>

        <div class="services-box owl-carousel owl-theme">

            

            <!-- ===================== المخاتير ===================== -->

            <div class="services-item"><div class="item-img"><img class="img-fluid" src="assets/images/team/امين موريس الخوري بطرس.JPG" alt=""></div></div>
            <div class="services-item"><div class="item-img"><img class="img-fluid" src="assets/images/team/ايلي عبده ابو حبيب.JPG" alt=""></div></div>
            <div class="services-item"><div class="item-img"><img class="img-fluid" src="assets/images/team/حميد قاسم المحمد.JPG" alt=""></div></div>
            <div class="services-item"><div class="item-img"><img class="img-fluid" src="assets/images/team/بيار نايف الأحمر.JPG" alt=""></div></div>
            <div class="services-item"><div class="item-img"><img class="img-fluid" src="assets/images/team/انطوان فارس ابو عبود.JPG" alt=""></div></div>

           

        </div>
    </div>
</section>

 <section class="services home-3 py-100-70">
    <div class="container">
        <div class="row">
            <div class="col-md-8 offset-md-2">
                <div class="sec-title text-center">
                    <h3> الأعضاء الاختياريّون </h3>
                </div>
            </div>
        </div>

        <div class="services-box owl-carousel owl-theme">

           

            <!-- ===================== الأعضاء الاختياريّون ===================== -->

            <div class="services-item"><div class="item-img"><img class="img-fluid" src="assets/images/team/بيار لنون ارسنيان مانوكيان.JPG" alt=""></div></div>
            <div class="services-item"><div class="item-img"><img class="img-fluid" src="assets/images/team/عصام قاسم الأحمد.JPG" alt=""></div></div>
            <div class="services-item"><div class="item-img"><img class="img-fluid" src="assets/images/team/عبدو جورج ابو عبود.JPG" alt=""></div></div>

        </div>
    </div>
</section>
        <!-- :: Contact -->
	<section class="contact text-center py-100">
    <div class="overlay-4"></div>
    <div class="container">
        <div class="row">
            <div class="col-md-8 offset-md-2">

                <!-- Logo -->
                <img class="img-fluid logo-contact" src="assets/images/logo/03_logo.png" alt="شعار البلدية">

                <!-- Title -->
                <div class="sec-title">
                    <h3>لِمَن يَهُمّهُ الأَمر</h3>
                </div>

                <!-- Intro Text -->
                <p class="contact-text mb-5">
                 لكل من يرغب بالتواصل معنا للحصول على معلومات أو تقديم مراجعات، نعلمكم بما يلي
                </p>

                
                <div class="phone-number text-right d-inline-block">

                    <p class="contact-text">
                          خلال الليل، يمكنكم التواصل مع مخفر الشرطة على الرقم<br>
                       
                    </p>
                    <div class="phone-number">01/682359</div>
                    <p class="contact-text">
                        خلال النهار، يمكنكم الاتصال برقم البلدية<br>
                    </p>
                    <div class="phone-number">01/682510 | 01/680127</div>
                    <p class="contact-text">
                          ولمراجعات خاصة أو مستعجلة، الرجاء الاتصال على الرقم<br>
                    </p>
                        <div class="phone-number">03/242007</div>
                </div>

               
            </div>
        </div>
    </div>
</section>


        
        <!-- :: Portfolio -->
		<!-- <section class="portfolio py-100-70">
            <div class="container">
                <div class="row">
                    <div class="col-md-8 offset-md-2">
                        <div class="sec-title text-center">
                            <h2>Our Portfolio</h2>
                            <h3>Case Solved</h3>
                        </div>
                    </div>
                </div>
                <div class="row">
                    <div class="col-md-6 col-lg-4">
                        <div class="portfolio-item">
                            <i class="fas fa-check"></i>
                            <div class="item-box">
                                <span>Evictions &amp; Housing</span>
                                <h4>Renting Aproperty In Foreclosure</h4>
                                <p>Lorem Ipsum is simply dummy text of the printing and typesetting industry simply dummy text typesetting.</p>
                                <a href="case-study_01.html">Read More</a>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-6 col-lg-4">
                        <div class="portfolio-item">
                            <i class="fas fa-check"></i>
                            <div class="item-box">
                                <span>Harassment &amp; Protection</span>
                                <h4>Protection From Harm to Children</h4>
                                <p>Lorem Ipsum is simply dummy text of the printing and typesetting industry simply dummy text typesetting.</p>
                                <a href="case-study_01.html">Read More</a>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-6 col-lg-4">
                        <div class="portfolio-item">
                            <i class="fas fa-check"></i>
                            <div class="item-box">
                                <span>Guardianship</span>
                                <h4>Family Law Self-Help Center's Guardianship</h4>
                                <p>Lorem Ipsum is simply dummy text of the printing and typesetting industry simply dummy text typesetting.</p>
                                <a href="case-study_01.html">Read More</a>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-6 col-lg-4">
                        <div class="portfolio-item">
                            <i class="fas fa-check"></i>
                            <div class="item-box">
                                <span>Forclosure Mediation</span>
                                <h4>Petition For Forclosure Mediation Assistance</h4>
                                <p>Lorem Ipsum is simply dummy text of the printing and typesetting industry simply dummy text typesetting.</p>
                                <a href="case-study_01.html">Read More</a>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-6 col-lg-4">
                        <div class="portfolio-item">
                            <i class="fas fa-check"></i>
                            <div class="item-box">
                                <span>Small Claims</span>
                                <h4>Appealing A Small Claims Judgment</h4>
                                <p>Lorem Ipsum is simply dummy text of the printing and typesetting industry simply dummy text typesetting.</p>
                                <a href="case-study_01.html">Read More</a>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-6 col-lg-4">
                        <div class="portfolio-item">
                            <i class="fas fa-check"></i>
                            <div class="item-box">
                                <span>Small Claims</span>
                                <h4>Mediating A Small Claims Dispute</h4>
                                <p>Lorem Ipsum is simply dummy text of the printing and typesetting industry simply dummy text typesetting.</p>
                                <a href="case-study_01.html">Read More</a>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </section> -->
        
  
       
        
       
        
        <!-- :: Blog -->
		<!-- <section class="blog py-100-70">
            <div class="container">
                <div class="row">
                    <div class="col-md-8 offset-md-2">
                        <div class="sec-title text-center">
                            <h2>Blog</h2>
                            <h3>News Feeds</h3>
                        </div>
                    </div>
                </div>
                <div class="row">
                    <div class="col-md-6 col-lg-4">
                        <div class="blog-item">
                            <div class="img-box">
                                <img class="img-fluid" src="assets/images/blog/01_blog.jpg" alt="01 Blog">
                            </div>
                            <div class="text-box">
                                <div class="admin-post">
                                    <img class="img-fluid" src="assets/images/testimonials-and-subscribe/01_testimonials.jpg" alt="01 Admin Post">
                                    <div class="info-post">
                                        <span>Anwar Ramadan</span>
                                        <span><i class="flaticon-calendar-1"></i> 12Th May 2019</span>
                                    </div>
                                </div>
                                <div class="post">
                                    <h5 class="title-post"><a href="blog_01.html">All you want to know about industrial laws</a></h5>
                                    <p>Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusm tempor incididunt ut labore et dolore magna aliqua...</p>
                                    <a href="blog_01.html" class="more">Read More</a>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-6 col-lg-4">
                        <div class="blog-item">
                            <div class="img-box">
                                <img class="img-fluid" src="assets/images/blog/02_blog.jpg" alt="02 Blog">
                            </div>
                            <div class="text-box">
                                <div class="admin-post">
                                    <img class="img-fluid" src="assets/images/testimonials-and-subscribe/02_testimonials.jpg" alt="02 Admin Post">
                                    <div class="info-post">
                                        <span>Ahmed Nagah</span>
                                        <span><i class="flaticon-calendar-1"></i> 18Th May 2019</span>
                                    </div>
                                </div>
                                <div class="post">
                                    <h5 class="title-post"><a href="blog_01.html">What you must know about financial law changes</a></h5>
                                    <p>Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusm tempor incididunt ut labore et dolore magna aliqua...</p>
                                    <a href="blog_01.html" class="more">Read More</a>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-6 col-lg-4">
                        <div class="blog-item">
                            <div class="img-box">
                                <img class="img-fluid" src="assets/images/blog/03_blog.jpg" alt="03 Blog">
                            </div>
                            <div class="text-box">
                                <div class="admin-post">
                                    <img class="img-fluid" src="assets/images/testimonials-and-subscribe/03_testimonials.jpg" alt="03 Admin Post">
                                    <div class="info-post">
                                        <span>Osama Bakri</span>
                                        <span><i class="flaticon-calendar-1"></i> 19Th May 2019</span>
                                    </div>
                                </div>
                                <div class="post">
                                    <h5 class="title-post"><a href="blog_01.html">Keep away from drugs, the penalty is 20 years</a></h5>
                                    <p>Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusm tempor incididunt ut labore et dolore magna aliqua...</p>
                                    <a href="blog_01.html" class="more">Read More</a>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </section> -->
        
    
        <!-- :: Footer -->
		<?php include 'footer.php';?>
        
        <!-- :: Scroll Up -->
        <div class="scroll-up">
            <a href="#page" class="move-section">
                <i class="fas fa-angle-up"></i>
            </a>
        </div>
        
        <!-- :: JS -->
        <!-- :: jQuery -->
        <script src="assets/js/jquery-3.5.1.min.js"></script>

        <!-- :: Popper -->
        <script src="assets/js/popper.min.js"></script>

        <!-- :: Bootstrap -->
        <script src="assets/js/bootstrap.min.js"></script>
        
        <!-- :: Owl Carousel -->
        <script src="assets/js/owl.carousel.min.js"></script>
        
        <!-- :: Waypoints -->
        <script src="assets/js/jquery.waypoints.min.js"></script>

        <!-- :: CounterUp -->
        <script src="assets/js/jquery.counterup.min.js"></script>
        
        <!-- :: Main -->
        <script src="assets/js/main.js"></script>
    </body>

</html>