<?php

ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);
include 'conn.php';
include 'auth.php';

// Session timeout 15 min
if ((time() - $_SESSION['last_login_timestamp']) > 900) {  
    header("location:logout.php");  
    exit;
} else {  
    $_SESSION['last_login_timestamp'] = time();  
}

$a = 10;

// حذف مشروع
if (isset($_GET['delete_id'])) {
    $del = intval($_GET['delete_id']);

    // جلب بيانات المشروع
    $selectdelete = mysqli_query($con, "SELECT * FROM projects WHERE id=$del");
    if ($selectimg = mysqli_fetch_assoc($selectdelete)) {

        // حذف الصورة إذا وجدت
        $path = 'uploads/';
        if (!empty($selectimg['img']) && file_exists($path.$selectimg['img'])) {
            unlink($path.$selectimg['img']);
        }

        // حذف المشروع من قاعدة البيانات
        mysqli_query($con, "DELETE FROM projects WHERE id=$del");
        echo "<script>alert('تم الحذف بنجاح'); window.location.href='view-projects.php';</script>";
        exit;
    }
}

// Pagination setup
$limit = 10;  
$page = isset($_GET["page"]) ? intval($_GET["page"]) : 1;  
$serial = ($page-1) * $limit; 

// جلب المشاريع
$resultt = mysqli_query($con, "SELECT * FROM projects ORDER BY id DESC LIMIT $serial, $limit");
?>

<!DOCTYPE html>
<html  lang="ar">
<head>
<meta charset="utf-8">
<meta http-equiv="X-UA-Compatible" content="IE=edge">
<?php include "title.php"; ?>
<meta name="viewport" content="width=device-width, initial-scale=1">
<link rel="stylesheet" href="plugins/fontawesome-free/css/all.min.css">
<link rel="stylesheet" href="dist/css/adminlte.min.css">
<link rel="stylesheet" href="plugins/summernote/summernote-bs4.css">
<link href="https://fonts.googleapis.com/css?family=Source+Sans+Pro:300,400,400i,700" rel="stylesheet">
</head>
<body class="hold-transition sidebar-mini">
<div class="wrapper">
<?php include "topbar.php"; ?>
<?php include "sidebar.php"; ?>

<div class="content-wrapper" style="font-family: 'Cairo', sans-serif;">
<section class="content-header">
<div class="container-fluid">
<div class="row mb-2">
<div class="col-sm-6"><h1>جميع المشاريع</h1></div>
<div class="col-sm-6" style="text-align:right;">
<a class="btn btn-primary" href="add-projects.php"><i class="fa fa-plus"></i> إضافة مشروع جديد</a>
</div>
</div>
</div>
</section>

<section class="content">
<div class="row">
<div class="col-md-12">
<div class="card card-info">
<div class="card-header"><h3 class="card-title">عرض المشاريع</h3></div>

<div class="card-body p-0">
<table class="table table-bordered">
<thead>
<tr>
<th>صورة المشروع</th>
<th>اسم المشروع</th>
<th>التصنيف</th>
<th>الوصف</th>
<th>الرابط</th>
<th>إجراءات</th>
</tr>
</thead>
<tbody>
<?php while($roww = mysqli_fetch_assoc($resultt)) { ?>
<tr>
<td>
<?php if(!empty($roww['img']) && file_exists('uploads/'.$roww['img'])): ?>
<img style="width:80px;" src="uploads/<?php echo $roww['img']; ?>" alt="Project Image">
<?php else: ?>
<span>لا توجد صورة</span>
<?php endif; ?>
</td>
<td><?php echo htmlspecialchars($roww['title']); ?></td>
<td><?php echo htmlspecialchars($roww['category']); ?></td>
<td><?php $desc = strip_tags($roww['description']); echo mb_substr($desc,0,100).'..'; ?></td>
<td>
<?php if(!empty($roww['url'])): ?>
<a href="<?php echo htmlspecialchars($roww['url']); ?>" target="_blank"><?php echo htmlspecialchars($roww['url']); ?></a>
<?php else: ?>
<span>لا يوجد رابط</span>
<?php endif; ?>
</td>
<td class="text-right py-0 align-middle">
<div class="btn-group btn-group-sm">
<a href="add-projects.php?edit=<?php echo $roww['id']; ?>" onclick="return confirm('هل أنت متأكد؟')" class="btn btn-info"><i class="fas fa-edit"></i></a>
<a href="view-projects.php?delete_id=<?php echo $roww['id']; ?>" onclick="return confirm('هل أنت متأكد من الحذف؟')" class="btn btn-danger"><i class="fas fa-trash"></i></a>
</div>
</td>
</tr>
<?php $serial++; } ?>
</tbody>
</table>
</div>

<?php
// Pagination
$result_db = mysqli_query($con, "SELECT COUNT(id) AS total FROM projects");
$row_db = mysqli_fetch_assoc($result_db);
$total_records = $row_db['total'];
$total_pages = ceil($total_records / $limit);

echo "<ul class='pagination'>";
for ($i=1; $i<=$total_pages; $i++) {
    echo "<li class='page-item'><a class='page-link' href='view-projects.php?page=".$i."'>".$i."</a></li>";
}
echo "</ul>";
?>

</div>
</div>
</div>
</section>
</div>

<?php include "footer.php"; ?>
<aside class="control-sidebar control-sidebar-dark"></aside>
</div>

<script src="plugins/jquery/jquery.min.js"></script>
<script src="plugins/bootstrap/js/bootstrap.bundle.min.js"></script>
<script src="dist/js/adminlte.min.js"></script>
<script src="plugins/summernote/summernote-bs4.min.js"></script>
<script>
$(function () { $('.textarea').summernote(); });
</script>
</body>
</html>
