<?php
error_reporting(E_ALL);
ini_set('display_errors', 1);

include 'conn.php';
include 'auth.php';

if ((time() - $_SESSION['last_login_timestamp']) > 900) {
    header("location:logout.php");
} else {
    $_SESSION['last_login_timestamp'] = time();
}

$a = 3;
?>
<!DOCTYPE html>
<html>
<head>
  <meta charset="utf-8">
  <meta http-equiv="X-UA-Compatible" content="IE=edge">
  <?php include "title.php"; ?>
  <meta name="viewport" content="width=device-width, initial-scale=1">

  <link rel="stylesheet" href="plugins/fontawesome-free/css/all.min.css">
  <link rel="stylesheet" href="https://code.ionicframework.com/ionicons/2.0.1/css/ionicons.min.css">
  <link rel="stylesheet" href="dist/css/adminlte.min.css">
  <link rel="stylesheet" href="plugins/summernote/summernote-bs4.css">
  <link href="https://fonts.googleapis.com/css?family=Source+Sans+Pro:300,400,400i,700" rel="stylesheet">
</head>

<body class="hold-transition sidebar-mini">
<div class="wrapper">

<?php include "topbar.php"; ?>
<?php include "sidebar.php"; ?>

<?php
date_default_timezone_set('Asia/Beirut');

if (!empty($_POST['news_date'])) {
    $today = date("Y-m-d", strtotime($_POST['news_date']));
} else {
    $today = date("Y-m-d");
}

$edit = $_GET['edit'] ?? '';

$roww = [];
if (!empty($edit)) {
    $resultt = mysqli_query($con, "SELECT * FROM news WHERE id=" . intval($edit));
    $roww = mysqli_fetch_array($resultt);
}

if (isset($_POST['publise'])) {

    $title = mysqli_real_escape_string($con, $_POST['title']);
    $category = $_POST['category'];
    $short = mysqli_real_escape_string($con, $_POST['short']);

    $lis_img = $_FILES['lis_img']['name'];
    $tempname = $_FILES['lis_img']['tmp_name'];

    if (empty($lis_img)) {
        $lis_img = $_POST['old_img'];
    } else {
        move_uploaded_file($tempname, 'uploads/' . $lis_img);
    }

    if ($edit == '') {
        mysqli_query($con, "INSERT INTO news (title, category, short, img, date, status)
        VALUES ('$title', '$category', '$short', '$lis_img', '$today', '0')");
        echo "<script>alert('تم النشر بنجاح');window.location='add-blog.php';</script>";
    } else {
        mysqli_query($con, "UPDATE news SET
        title='$title',
        category='$category',
        short='$short',
        img='$lis_img',
        date='$today'
        WHERE id=" . intval($edit));
        echo "<script>alert('تم التحديث بنجاح');window.location='add-blog.php';</script>";
    }
}
?>

<div class="content-wrapper" style="font-family: Poppins, sans-serif;">

<section class="content-header">
  <div class="container-fluid">
    <div class="row mb-2">
      <div class="col-sm-6">
        <h1>إضافة خبر / إعلان</h1>
      </div>
      <div class="col-sm-6">
        <a href="view-blog.php" class="btn btn-success">
          <i class="fa fa-eye"></i> عرض الأخبار والإعلانات
        </a>
      </div>
    </div>
  </div>
</section>

<section class="content">
<div class="row">
<div class="col-md-8">

<form method="post" enctype="multipart/form-data">
<div class="card card-outline card-info">

<div class="card-header">
  <div class="form-group">
    <label>عنوان الخبر / الإعلان</label>
    <input type="text" name="title" class="form-control"
           value="<?php echo $roww['title'] ?? ''; ?>" placeholder="أدخل العنوان">
  </div>
</div>

<div class="card-header">
  <div class="form-group">
    <label>اختر التصنيف</label>
    <select name="category" class="form-control">
      <option>اختر...</option>
      <?php
      $cats = mysqli_query($con, "SELECT * FROM category");
      while ($c = mysqli_fetch_array($cats)) {
      ?>
        <option value="<?php echo $c['cat_name']; ?>"
          <?php if (($roww['category'] ?? '') == $c['cat_name']) echo 'selected'; ?>>
          <?php echo $c['cat_name']; ?>
        </option>
      <?php } ?>
    </select>
  </div>
</div>



<div class="card-body pad">
  <label>الوصف</label>
  <textarea name="short" rows="5" class="form-control"><?php echo $roww['short'] ?? ''; ?></textarea>
</div>

<div class="card-header">
  <div class="form-group">
    <label>تاريخ الخبر</label>
    <input type="date" name="news_date" class="form-control"
           value="<?php 
           if (!empty($roww['date'])) {
               echo date('Y-m-d', strtotime($roww['date']));
           }
           ?>">
  </div>
</div>


<div class="card-header">
  <div class="form-group">
    <label>الملف الحالي</label><br>
    <?php if (!empty($roww['img'])) { ?>
      <a href="uploads/<?php echo $roww['img']; ?>" target="_blank"><?php echo $roww['img']; ?></a><br><br>
    <?php } ?>
    <label>رفع ملف جديد</label><br>
    <input type="file" name="lis_img">
    <input type="hidden" name="old_img" value="<?php echo $roww['img'] ?? ''; ?>">
  </div>
</div>

<div class="card-header">
  <button type="submit" name="publise" class="btn btn-warning btn-lg btn-block">
    نشر
  </button>
</div>

</div>
</form>

</div>
</div>
</section>

</div>

<?php include "footer.php"; ?>

</div>

<script src="plugins/jquery/jquery.min.js"></script>
<script src="plugins/bootstrap/js/bootstrap.bundle.min.js"></script>
<script src="dist/js/adminlte.min.js"></script>
<script src="plugins/summernote/summernote-bs4.min.js"></script>
</body>
</html>
