<!DOCTYPE html>
<html lang="en">
    
<meta http-equiv="content-type" content="text/html;charset=utf-8" />
<head>
        <!-- :: Required Meta Tags -->
        <meta charset="utf-8">
        <meta http-equiv="X-UA-Compatible" content="IE=edge">
        <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
        <meta name="description" content="">
        <meta name="keywords" content="">
        
        <!-- :: Favicon -->
        <link rel="icon" type="image/png" href="assets/images/favicon.png">

        <!-- :: Title -->
        <title>Dekwaneh Municipality</title>

        <!-- :: Google Fonts -->
        <link rel="stylesheet" href="https://fonts.googleapis.com/css2?family=Open+Sans:wght@400;600;700;800&amp;display=swap">
        <link rel="stylesheet" href="https://fonts.googleapis.com/css2?family=Raleway:wght@400;600;700;800&amp;display=swap">
                
        <!-- :: Flaticon CSS -->
        <link rel="stylesheet" href="assets/fonts/flaticon/css/flaticon.css">
        
        <!-- :: Fontawesome CSS -->
		<link rel="stylesheet" href="assets/fonts/fontawesome/css/all.min.css">

        <!-- :: Bootstrap CSS -->
        <link rel="stylesheet" href="assets/css/bootstrap.min.css">
        
        <!-- :: Owl Carousel CSS -->
        <link rel="stylesheet" href="assets/css/owl.carousel.min.css">
        <link rel="stylesheet" href="assets/css/owl.theme.default.css">
        
        <!-- :: Animate CSS -->
        <link rel="stylesheet" href="assets/css/animate.css">
        
        <!-- :: Style CSS -->
        <link rel="stylesheet" href="assets/css/style.css">

        <!-- :: Style Responsive CSS -->
        <link rel="stylesheet" href="assets/css/responsive.css">
        <link href="https://fonts.googleapis.com/css2?family=Tajawal:wght@300;400;500;700&family=Cairo:wght@400;600;700&display=swap" rel="stylesheet">

        <!--[if lt IE 9]>
            <script src="https://oss.maxcdn.com/libs/html5shiv/3.7.0/html5shiv.js"></script>
            <script src="https://oss.maxcdn.com/libs/respond.js/1.4.2/respond.min.js"></script>
        <![endif]-->
    </head>
    <body>
        <!-- :: Loading -->
        <div class="loading">
            <div class="banner">
                <div class="sk-chase">
                    <div class="sk-chase-dot"></div>
                    <div class="sk-chase-dot"></div>
                    <div class="sk-chase-dot"></div>
                    <div class="sk-chase-dot"></div>
                    <div class="sk-chase-dot"></div>
                    <div class="sk-chase-dot"></div>
                </div>
            </div>
        </div>
        
        <!-- :: Header Bar -->
       <?php include 'header.php';?>

        <!-- :: Breadcrumb Header -->
		<section class="breadcrumb-header" id="page">
            <div class="overlay"></div>
            <div class="container">
                <div class="breadcrumb-info text-right">
                    <h1>عن البلدية</h1>
                   
                </div>
            </div>
        </section>

      
        
        <!-- :: About the Municipality -->
        <section class="about py-100" id="about">
    <div class="overlay-2"></div>
    <div class="container">
        <div class="row">
            <div class="col-lg-12">
                <div class="text-box">

                    <!-- Section Title -->
                    <div class="sec-title text-center mb-5">
                        <h2>عن البلدية</h2>
                        <h3>الدكوانة</h3>
                    </div>

                    <!-- Historical Overview -->
                    <h4 class="title-dark">نبذة تاريخية</h4>
                    <p>
                        بلدية الدكوانة – مار روكس – ضهر الحصين هي من البلديات العريقة في لبنان، إذ تعود جذورها
                        التاريخية إلى عصور قديمة سبقت الميلاد، وارتبط اسمها وجغرافيتها بتاريخ الحضارات التي
                        تعاقبت على لبنان، لا سيما الفينيقية، الآرامية، السريانية، الرومانية واليونانية.
                    </p>

                    <p>
                        تأسست بلدية الدكوانة رسمياً عام <strong>1952</strong> بمرسوم صادر عن رئاسة الجمهورية
                        اللبنانية، وكانت من أهم البلديات نظراً لدورها الاقتصادي والتجاري والإداري، حيث اعتُبرت
                        مركزاً حيوياً في محافظة جبل لبنان، وتبعت مباشرة لوزارة الداخلية.
                    </p>

                    <!-- Linguistic Roots -->
                    <h4 class="title-dark">أصول التسمية في القرى اللبنانية</h4>
                    <p>
                        أطلق الإنسان عبر التاريخ الأسماء على الأماكن التي سكنها، كما على النباتات والحيوانات
                        والمصطلحات المرتبطة بحياته اليومية. ويعود عدد كبير من أسماء القرى والمدن اللبنانية
                        الحالية إلى أصول أرامية وسريانية وعبرية وفينيقية ورومانية ويونانية.
                    </p>

                    <p>
                        تحمل حوالي <strong>520 بلدة</strong> من أصل نحو <strong>2000 بلدة لبنانية</strong>
                        أسماء مركبة تعود إلى ما قبل السيد المسيح، لا سيما في اللغات الآرامية والسريانية
                        والعبرية، مع إضافة توصيف جغرافي أو عمراني لكل اسم.
                    </p>

                    <p>
                        من أبرز هذه المفردات:
                        <br>– <strong>عين</strong>: مثل «عينطور» أي عين الجبل.
                        <br>– <strong>مجدل</strong>: مثل «مجدلون» أي البرج الصغير.
                        <br>– <strong>كفر</strong>: مثل «كفرشيما» أي قرية الفضة.
                    </p>

                    <!-- B Prefix Explanation -->
                    <h4 class="title-dark">القرى التي تبدأ بحرف «ب»</h4>
                    <p>
                        تشير الدراسات اللغوية إلى أن حرف «ب» في اللغات القديمة يعني «البيت» أو «المعبد» أو
                        «المكان» أو «المقام». ومن هنا جاءت أسماء كثيرة مثل:
                    </p>

                    <p>
                        – <strong>بكفيا</strong>: بيت كيفا، أي بيت الصخر.<br>
                        – <strong>بصاليم</strong>: بيت ساليم (بيت الصنم).<br>
                        – <strong>برمانا</strong>: بيت رمانا، معبد الإله الفينيقي رمانا.<br>
                        – <strong>بسكنتا</strong>: بيت سنكن، الشاعر الفينيقي المعروف.<br>
                        – <strong>بعبدات</strong>: بيت العبادة.<br>
                        – <strong>بتغرين</strong>: مكان الصخور والحجارة.
                    </p>

                    <p>
                        وقد جعل الفينيقيون هذه المناطق، ولا سيما التلال والمرتفعات في المتن، أماكن لعبادتهم،
                        كما تشهد على ذلك الآثار المكتشفة من قلاع ونواويس وجرار وعملات. وقد كتب المؤرخ الفرنسي
                        إرنست رينان: «الشاطئ اللبناني جعلته اليد الفينيقية الجبارة حصناً منيعاً».
                    </p>

                    <!-- Dekwaneh Name -->
                    <h4 class="title-dark">تفسير اسم الدكوانة</h4>
                    <p>
                        التفسير العلمي لاسم الدكوانة يُرجّح اشتقاقه من اللغة السريانية:
                        <br>– <strong>Dukkana</strong>: وتعني الدكان أو مكان العمل أو الورشة.
                        <br>– <strong>Dakuna</strong>: وتعني العلية أو المكان المرتفع أو المصطبة.
                    </p>

                    <p>
                        خلال القرنين الثامن عشر والتاسع عشر، كانت الدكوانة محطة استراحة للمكارية الذين ينقلون
                        البضائع بين قرى المتن الجبلية وبيروت والساحل، وقد وُجدت «دكانة» مركزية في ساحة
                        الدكوانة الحالية، ومنها يُعتقد أن الاسم انتشر.
                    </p>

                    <p>
                        وتورد رواية شعبية أخرى أن سيدة فقدت ديكها، فكانت تنادي عليه، ومع الزمن تحوّل النداء
                        إلى اسم «الدكوانة»، وهي رواية شعبية غير علمية.
                    </p>

                    <!-- Mar Roukoz & Dahr El Hossain -->
                    <h4 class="title-dark">مار روكس – ضهر الحصين</h4>
                    <p>
                        كلمة «روكس» هي نفسها «روكز»، نسبة إلى القديس مار روكز شفيع المرضى. وقد حملت المنطقة
                        اسمه بعد إقامة دير مار روكز للرهبان الأنطونيين في أعالي البلدة.
                    </p>

                    <p>
                        أما «ضهر الحصين» فيشير إلى الهضبة المرتفعة، حيث تعني كلمة «ظهر» المكان العالي،
                        و«الحصين» نسبة إلى حصن صغير شُيّد من حجارة متوسطة الحجم.
                    </p>

                    <p>
                        تختلف الروايات حول الحصين، فإحداها تنسبه إلى المردة في القرن الثامن، حيث ضم كنيسة
                        صغيرة باسم القديس بطرس، بينما تشير رواية أخرى إلى استخدامه من قبل الأمير التنوخي
                        عبد الله بن النعمان في القرن التاسع.
                    </p>

                    <!-- Unification -->
                    <h4 class="title-dark">توحيد اسم البلدة</h4>
                    <p>
                        رغم وحدة التاريخ والسكان، بقيت الدكوانة وضهر الحصين منطقتين منفصلتين إلى أن تم
                        ضم منطقة مار روكس – ضهر الحصين رسمياً إلى بلدة الدكوانة عام <strong>1981</strong>
                        بجهود أنطوان نقولا شختورة، ليصبح الاسم الرسمي:
                        <strong>الدكوانة – مار روكس – ضهر الحصين</strong>.
                    </p>

                    <!-- Municipality Development -->
                    <h4 class="title-dark">نشوء وتطور بلدية الدكوانة</h4>
                    <p>
                        تأسست بلدية الدكوانة عام 1952، وشكّلت منذ ذلك الحين مركزاً اقتصادياً وإدارياً مهماً
                        في جبل لبنان، وأسهمت في تنظيم الشؤون المحلية وتطوير الخدمات العامة.
                    </p>

                    <!-- Municipal Councils -->
                    <h4 class="title-dark">المجالس البلدية عبر التاريخ</h4>
                    <ul class="title-dark">
                        <li>رئيس البلدية الأول: إبراهيم طعمة أبو نصر</li>
                        <li>الرئيس الثاني: موسى المعلوف</li>
                        <li>الرئيس الثالث: سليم الشقفشي</li>
                        <li>الرئيس الرابع: الدكتور جورج عبود</li>
                        <li>الرئيس الخامس: الدكتور يوسف الجعني</li>
                        <li>الرئيس السادس: ريمون رزق</li>
                        <li>الرئيس السابع: مارون ضاهر</li>
                    </ul>
                    <br>
                    <!-- Elections -->
                    <h4 class="title-dark">نتائج أول مجلس بلدي – 1952</h4>
                    <p>
                        الرئيس: إبراهيم طعمة أبو نصر<br>
                        الأعضاء: كامل الشويري، نجيب أسبر، إبراهيم فرحات، أحمد عبيد<br>
                        عدد الناخبين: حوالي 483 ناخباً
                    </p>

                </div>
            </div>
        </div>
    </div>
</section>

        
            <section class="services home-3 py-100-70">
        <div class="container">
            <div class="row">
                <div class="col-md-8 offset-md-2">
                    <div class="sec-title text-center">
                        <h2>أعضاء المجلس البلدي</h2>
                        <h3> البلدية </h3>
                    </div>
                </div>
            </div>
    
            <div class="services-box owl-carousel owl-theme">
    
                <!-- ===================== البلدية ===================== -->
             
    
                <div class="services-item"><div class="item-img"><img class="img-fluid" src="assets/images/team/انطوان انطوان شختورة.JPG" alt=""></div></div>
                <div class="services-item"><div class="item-img"><img class="img-fluid" src="assets/images/team/جورج روكس صادر.JPG" alt=""></div></div>
                <div class="services-item"><div class="item-img"><img class="img-fluid" src="assets/images/team/داني متري متى.JPG" alt=""></div></div>
                <div class="services-item"><div class="item-img"><img class="img-fluid" src="assets/images/team/ريمون آليا أبي عبود.JPG" alt=""></div></div>
                <div class="services-item"><div class="item-img"><img class="img-fluid" src="assets/images/team/زياد أنيس وازن.JPG" alt=""></div></div>
    
                <div class="services-item"><div class="item-img"><img class="img-fluid" src="assets/images/team/ميرنا زخيا صفير.JPG" alt=""></div></div>
                <div class="services-item"><div class="item-img"><img class="img-fluid" src="assets/images/team/طوني جوزف رزق.JPG" alt=""></div></div>
                <div class="services-item"><div class="item-img"><img class="img-fluid" src="assets/images/team/مارون عبدو الناكوزي.JPG" alt=""></div></div>
                <div class="services-item"><div class="item-img"><img class="img-fluid" src="assets/images/team/زكريا عطيه سلوم.JPG" alt=""></div></div>
                <div class="services-item"><div class="item-img"><img class="img-fluid" src="assets/images/team/تانيا جورج بوعبود.JPG" alt=""></div></div>
    
                <div class="services-item"><div class="item-img"><img class="img-fluid" src="assets/images/team/جان الياس الصيفي.JPG" alt=""></div></div>
                <div class="services-item"><div class="item-img"><img class="img-fluid" src="assets/images/team/بيار عبده عطالله.JPG" alt=""></div></div>
                <div class="services-item"><div class="item-img"><img class="img-fluid" src="assets/images/team/رالف ابراهيم جدعون.JPG" alt=""></div></div>
                <div class="services-item"><div class="item-img"><img class="img-fluid" src="assets/images/team/جوزف عبده الحمصي.JPG" alt=""></div></div>
    
               
    
            </div>
        </div>
    </section>

         <section class="services home-3">
    <div class="container">
        <div class="row">
            <div class="col-md-8 offset-md-2">
                <div class="sec-title text-center">
                    <h3>المخاتير </h3>
                </div>
            </div>
        </div>

        <div class="services-box owl-carousel owl-theme">

            

            <!-- ===================== المخاتير ===================== -->

            <div class="services-item"><div class="item-img"><img class="img-fluid" src="assets/images/team/امين موريس الخوري بطرس.JPG" alt=""></div></div>
            <div class="services-item"><div class="item-img"><img class="img-fluid" src="assets/images/team/ايلي عبده ابو حبيب.JPG" alt=""></div></div>
            <div class="services-item"><div class="item-img"><img class="img-fluid" src="assets/images/team/حميد قاسم المحمد.JPG" alt=""></div></div>
            <div class="services-item"><div class="item-img"><img class="img-fluid" src="assets/images/team/بيار نايف الأحمر.JPG" alt=""></div></div>
            <div class="services-item"><div class="item-img"><img class="img-fluid" src="assets/images/team/انطوان فارس ابو عبود.JPG" alt=""></div></div>

           

        </div>
    </div>
</section>

 <section class="services home-3 py-100-70">
    <div class="container">
        <div class="row">
            <div class="col-md-8 offset-md-2">
                <div class="sec-title text-center">
                    <h3> الأعضاء الاختياريّون </h3>
                </div>
            </div>
        </div>

        <div class="services-box owl-carousel owl-theme">

           

            <!-- ===================== الأعضاء الاختياريّون ===================== -->

            <div class="services-item"><div class="item-img"><img class="img-fluid" src="assets/images/team/بيار لنون ارسنيان مانوكيان.JPG" alt=""></div></div>
            <div class="services-item"><div class="item-img"><img class="img-fluid" src="assets/images/team/عصام قاسم الأحمد.JPG" alt=""></div></div>
            <div class="services-item"><div class="item-img"><img class="img-fluid" src="assets/images/team/عبدو جورج ابو عبود.JPG" alt=""></div></div>

        </div>
    </div>
</section>
        
        
        <!-- :: Footer -->
		<?php include 'footer.php';?>
        
        <!-- :: Scroll Up -->
        <div class="scroll-up">
            <a href="#page" class="move-section">
                <i class="fas fa-angle-up"></i>
            </a>
        </div>
        
        <!-- :: JS -->
        <!-- :: jQuery -->
        <script src="assets/js/jquery-3.5.1.min.js"></script>

        <!-- :: Popper -->
        <script src="assets/js/popper.min.js"></script>

        <!-- :: Bootstrap -->
        <script src="assets/js/bootstrap.min.js"></script>
        
        <!-- :: Owl Carousel -->
        <script src="assets/js/owl.carousel.min.js"></script>
        
        <!-- :: Waypoints -->
        <script src="assets/js/jquery.waypoints.min.js"></script>

        <!-- :: CounterUp -->
        <script src="assets/js/jquery.counterup.min.js"></script>
        
        <!-- :: Main -->
        <script src="assets/js/main.js"></script>
    </body>

</html>